package nl.ivojonker.icn.configuration;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;

/**
 * A helper class to serialize and deserialize the configuration as JSON.
 * 
 * This is intentionally an external class so the Configuration.java can be used on webspheres without the com.ibm.json libraries.
 * 
 * Preferably a decent json serializer/deserializer i used such as gson of jackson. But instead custom functions are made to convert from {@link ConfigurationEntry} to {@link JSONObject}
 * 
 * @author nl.ivojonker
 *
 */
public class ConfigurationJSON {


	/**
	 * Retrieve the configuration as JSONArray.  
	 * @param exposedOnly filter setting to serialize only those entries that are marked 'exposed' (e.g. passwords shouldnt be exposed as they're viewable in plain text)
	 * @return
	 * @throws SQLException
	 */
	public static JSONArray getConfigAsJSONArray(boolean exposedOnly) throws SQLException{

		ArrayList<ConfigurationEntry> config = Configuration.getInstance(false).getRawConfig();

		JSONArray array = new JSONArray(config.size());

		for (ConfigurationEntry ce : config){
			if (ce.getExpose() || !exposedOnly)
				array.add(translate(ce));
		}
		return array ; 
	}

	
	public static void persistConfigFromJSONArray(JSONArray configToPersist) throws SQLException {
		Configuration.getInstanceSupressExceptions(false).persist(translate(configToPersist));
	}
	
	
	
	private static ArrayList<ConfigurationEntry> translate(JSONArray json){
		ArrayList<ConfigurationEntry> result = new ArrayList<ConfigurationEntry>(json.size());
		
		for (Object object : json) {
			if (object instanceof JSONObject)
				result.add(translate((JSONObject)object));
			else
				throw new RuntimeException("Wrong configuration format.");
		}
		return result;
	}
	
	private static ConfigurationEntry translate(JSONObject json){
		return new ConfigurationEntry(
				(String)json.get("key"), 
				(String)json.get("value"), 
				(Boolean)json.get("evaluate"), 
				(Boolean)json.get("expose"),
				(String)json.get("description"));
	}
	
	private static JSONObject translate(ConfigurationEntry entry){
		JSONObject json = new JSONObject();
		json.put("key", entry.getKey());
		json.put("value", entry.getValue());
		json.put("evaluate", entry.getEvaluate());
		json.put("expose", entry.getExpose());
		json.put("description", entry.getDescription());
		return json;
	}

}
